#ifdef WIN32

#include "MeetingService.h"
#include "CMRMeetingCallback.h"
#include "CMRController.h"
#include "csfunified/services/impl/notifiers/UnifiedServiceNotifiersImpl.h"

#include <string>
#include <vector>
#include <map>


class MockCMRController : public CSFUnified::CMRController
{
	public:
	
	std::string jid;
	std::string hostJid;
	std::string sipUrl;
	std::string hostPin;
	std::string guestPin;
	std::string joinUrl;
	std::string joinParam;
	bool isHost;
	bool hasCalledStart;
	bool autoStarted;
	bool hasCalledJoin;
	
	MockCMRController() : isHost(false), hasCalledStart(false), autoStarted(false), hasCalledJoin(false)
	{
		
	}
	virtual void addObserver(SMART_PTR_NS::weak_ptr<CSFUnified::UnifiedBusinessObjectObserver> observer)
	{

	}

	virtual void addObserver(SMART_PTR_NS::weak_ptr<CSFUnified::CMRControllerObserver> observer)
	{

	}


	virtual void removeObserver(SMART_PTR_NS::weak_ptr<CSFUnified::CMRControllerObserver> observer)
	{

	}

	virtual void removeObserver(SMART_PTR_NS::weak_ptr<CSFUnified::UnifiedBusinessObjectObserver> observer)
	{

	}

	virtual std::string getGuid()
	{
		return "";
	}

	virtual std::string toString()
	{
		return "";
	}

	virtual SMART_PTR_NS::shared_ptr<CSFUnified::UnifiedBusinessObjectNotifiers> getUnifiedBusinessObjectNotifiers()
	{
		return SMART_PTR_NS::shared_ptr<CSFUnified::UnifiedBusinessObjectNotifiers>();
	}

	virtual SMART_PTR_NS::shared_ptr<CSFUnified::CMRControllerNotifiers> getCMRControllerNotifiers() 
	{
		return SMART_PTR_NS::shared_ptr<CSFUnified::CMRControllerNotifiers>();
	}

	virtual bool getisHost() 
	{
		return isHost;
	}
	virtual std::string getJID() 
	{
		return jid;
	}
	virtual std::string gethostJID() 
	{
		return hostJid;
	}
	virtual std::string getsipUrl() 
	{
		return sipUrl;
	}
	virtual std::string gethostPin() 
	{
		return hostPin;
	}
	virtual std::string getguestPin()
	{
		return guestPin;
	}
	virtual std::string getjoinUrl() 
	{
		return joinUrl;
	}
	virtual std::string getjoinParam()
	{
		return joinParam;
	}

	virtual void start(bool isAutoStartMeeting) 
	{
		hasCalledStart = true;
		autoStarted = isAutoStartMeeting;
	}
	virtual void join(std::string joinParam) 
	{
		hasCalledJoin = true;
	}

};

class MockMeetingServiceNotifiers : public CSFUnified::UnifiedServiceNotifiersImpl, public virtual CSFUnified::MeetingServiceNotifiers
{
public:
	MockMeetingServiceNotifiers() : isCMREnabledNotifier(new CSFUnified::PropertyNotifierImpl())
	{

	}
	virtual SMART_PTR_NS::shared_ptr<CSFUnified::PropertyListNotifier<CSFUnified::Meeting> > getMeetingsNotifier()
	{
		return SMART_PTR_NS::shared_ptr<CSFUnified::PropertyListNotifier<CSFUnified::Meeting> >();
	}
	virtual SMART_PTR_NS::shared_ptr<CSFUnified::PropertyNotifier> getMeetingContentNotifier()
	{
		return SMART_PTR_NS::shared_ptr<CSFUnified::PropertyNotifier>();
	}
	virtual SMART_PTR_NS::shared_ptr<CSFUnified::PropertyNotifier> getOnlineSwitchNotifier()
	{
		return SMART_PTR_NS::shared_ptr<CSFUnified::PropertyNotifier>();
	}
	virtual SMART_PTR_NS::shared_ptr<CSFUnified::PropertyNotifier> getOfflineSwitchNotifier()
	{
		return SMART_PTR_NS::shared_ptr<CSFUnified::PropertyNotifier>();
	}
	virtual SMART_PTR_NS::shared_ptr<CSFUnified::PropertyNotifier> getIntegrationTypeNotifier()
	{
		return SMART_PTR_NS::shared_ptr<CSFUnified::PropertyNotifier>();
	}
	virtual SMART_PTR_NS::shared_ptr<CSFUnified::PropertyNotifier> getIsCMREnabledNotifier()
	{
		return isCMREnabledNotifier;
	}

	SMART_PTR_NS::shared_ptr<CSFUnified::PropertyNotifier> isCMREnabledNotifier;
};

class MockWinMeetingService : public CSFUnified::MeetingService
{
	  public:
	  
		SMART_PTR_NS::shared_ptr<MockMeetingServiceNotifiers> notifiers;
		bool isCMREnabled;
		bool hasCalledRegisterCMRMeetingCallback;
		bool hasCalledUnregisterCMRMeetingCallback;

		std::map<std::string, SMART_PTR_NS::shared_ptr<CSFUnified::CMRController> > controllers;
	  
	  
		MockWinMeetingService() : 
			isCMREnabled(false),
			hasCalledRegisterCMRMeetingCallback(false),
			hasCalledUnregisterCMRMeetingCallback(false),
			notifiers(new MockMeetingServiceNotifiers)
		{
			
		}

		virtual std::string getGuid()
		{
			return "";
		}

		virtual std::string toString()
		{
			return "";
		}

		virtual SMART_PTR_NS::shared_ptr<CSFUnified::PropertyNotifier> getGuidNotifier()
		{
			return SMART_PTR_NS::shared_ptr<CSFUnified::PropertyNotifier>();
		}

		virtual SMART_PTR_NS::shared_ptr<CSFUnified::PropertyNotifier> getBulkUpdateInProgressNotifier()
		{
			return SMART_PTR_NS::shared_ptr<CSFUnified::PropertyNotifier>();
		}

		virtual SMART_PTR_NS::shared_ptr<CSFUnified::UnifiedBusinessObjectNotifiers> getUnifiedBusinessObjectNotifiers()
		{
			return SMART_PTR_NS::shared_ptr<CSFUnified::UnifiedBusinessObjectNotifiers>();
		}

		virtual void addObserver(SMART_PTR_NS::weak_ptr<CSFUnified::MeetingServiceObserver> observer)
		{

		}
		
		virtual void addObserver(SMART_PTR_NS::weak_ptr<CSFUnified::UnifiedServiceObserver> observer)
		{
			
		}

		virtual void addObserver(SMART_PTR_NS::weak_ptr<CSFUnified::UnifiedBusinessObjectObserver> observer)
		{

		}

		virtual void removeObserver(SMART_PTR_NS::weak_ptr<CSFUnified::MeetingServiceObserver> observer)
		{

		}

		virtual void removeObserver(SMART_PTR_NS::weak_ptr<CSFUnified::UnifiedServiceObserver> observer)
		{
			
		}

		virtual void removeObserver(SMART_PTR_NS::weak_ptr<CSFUnified::UnifiedBusinessObjectObserver> observer)
		{

		}


		virtual SMART_PTR_NS::shared_ptr< CSFUnified::UnifiedServiceNotifiers > getUnifiedServiceNotifiers()
		{
			return SMART_PTR_NS::shared_ptr< CSFUnified::UnifiedServiceNotifiers >();
		}
        
        virtual SMART_PTR_NS::shared_ptr<CSFUnified::MeetingServiceNotifiers> getMeetingServiceNotifiers()
		{
			return notifiers;
		}

		virtual bool getBulkUpdateInProgress()
		{
			return false;
		}

        #pragma endregion

        #pragma region Properties

        
        #pragma region Meetings
    
        virtual SMART_PTR_NS::shared_ptr<std::vector<SMART_PTR_NS::shared_ptr<CSFUnified::Meeting> > > getMeetings()
		{
			return SMART_PTR_NS::shared_ptr<std::vector<SMART_PTR_NS::shared_ptr<CSFUnified::Meeting> > >();
		}
        virtual std::string getMeetingContent()
		{
			return "";
		}
        virtual BOOL getOnlineSwitch()
		{
			return FALSE;
		}
        virtual BOOL getOfflineSwitch()
		{
			return FALSE;
		}
        virtual int getIntegrationType()
		{
			return 0;
		}
        virtual void setIntegrationType(int update)
		{
			
		}
        virtual bool getIsCMREnabled()
		{
			return isCMREnabled;
		}
      
        virtual bool IsWebExMeetingModuleEnable()
		{
			return false;
		}
        virtual bool IsDesktopShareModuleEnable()
		{
			return false;
		}
        virtual SMART_PTR_NS::shared_ptr<CSFUnified::CMRController> getCMRController(std::string JID) 
		{
			std::map<std::string, SMART_PTR_NS::shared_ptr<CSFUnified::CMRController> >::iterator i = controllers.find(JID);
			
			if(i == controllers.end())
			{
				SMART_PTR_NS::shared_ptr<MockCMRController> cmr(new MockCMRController);
				cmr->jid = JID;
				controllers[JID] = cmr;
				return cmr;
			}
			else
			{
				return i->second;
			}
		}
        
        virtual void registerCMRMeetingCallback(SMART_PTR_NS::shared_ptr<CSFUnified::CMRMeetingCallback> cmrCallback)
		{
			hasCalledRegisterCMRMeetingCallback = true;
		}
        virtual void unregisterCMRMeetingCallback(SMART_PTR_NS::shared_ptr<CSFUnified::CMRMeetingCallback> cmrCallback)
		{
			hasCalledUnregisterCMRMeetingCallback = true;
		}
        #pragma endregion

        #pragma region InstantMeetings
    
        virtual void RegisterInstantMeetingCallback(SMART_PTR_NS::shared_ptr<CSFUnified::InstantMeetingCallback> instantMeetingCallback) 
		{
			
		}
        virtual void UnregisterInstantMeetingCallback(SMART_PTR_NS::shared_ptr<CSFUnified::InstantMeetingCallback> instantMeetingCallback)
		{
			
		}
        virtual bool IsInMeeting()
		{
			return false;
		}
        virtual bool CanStartMeeting()
		{
			return false;
		}
        virtual bool CanJoinMeeting()
		{
			return false;
		}
        virtual bool StartInstantMeeting(std::string meetingName, SMART_PTR_NS::shared_ptr<std::vector<std::string> > vecInviteList)
		{
			return false;
		}
        virtual bool InviteUser2InstantMeeting(std::string strBuddyName)
		{
			return false;
		}
        virtual bool StartScheduledMeeting(std::string strMeetingKey)
		{
			return false;
		}
        virtual bool JoinMeetingByMK(std::string strMeetingKey)
		{
			return false;
		}
        virtual bool AcceptMeetingInviataion(std::string strSessioName)
		{
			return false;
		}
        virtual bool DeclineMeetingInviataion(std::string strSessioName)
		{
			return false;
		}
        virtual int GetInstantMeetingLastErrCode()
		{
			return 0;
		}
        virtual std::string GetInstantMeetingLastErrMsg()
		{
			return "";
		}
        virtual void EditOneClickSetting()
		{
		}
        virtual bool OpenMeetingDetailPage(std::string strURL)
		{
			return false;
		}
        virtual bool StartJoinMeetingByUrl(std::string strURL)
		{
			return false;
		}
        #pragma endregion

        #pragma region MeetingAccountMgr
    
        virtual void RegisterMeetingAccountMgrCallback(SMART_PTR_NS::shared_ptr<CSFUnified::MeetingAccountMgrCallback> meetingAccountMgrCallback)
		{
		}
        virtual void UnregisterMeetingAccountMgrCallback(SMART_PTR_NS::shared_ptr<CSFUnified::MeetingAccountMgrCallback> meetingAccountMgrCallback)
		{
		}
        virtual BOOL IsReady()
		{
			return FALSE;
		}
        virtual BOOL IsActive()
		{
			return FALSE;
		}
        virtual int GetAllAccountCount()
		{
			return 0;
		}
        virtual SMART_PTR_NS::shared_ptr<CSFUnified::WbxMeetingAccountObject> GetAccountByIndex(unsigned int index)
		{
			return SMART_PTR_NS::shared_ptr<CSFUnified::WbxMeetingAccountObject>();
		}
        virtual SMART_PTR_NS::shared_ptr<CSFUnified::WbxMeetingAccountObject> GetDefaultAccount()
		{
			return SMART_PTR_NS::shared_ptr<CSFUnified::WbxMeetingAccountObject>();
		}
        virtual void DelAccount(std::string siteURL)
		{
		}
        virtual void AddAccount(std::string siteURL, std::string userName, csf::SecureString userPass, bool bSSO)
		{
		}
        virtual int GetMeetingAccountLastErrCode()
		{
			return 0;
		}
        virtual std::string GetMeetingAccountLastErrMsg()
		{
			return "";
		}
        virtual void CheckSSOSite(std::string strSiteUrl)
		{
		}
        virtual int IsSSOSite(std::string strSiteUrl)
		{
			return 0;
		}
        virtual void InitializeAccountFitting(void * hSSOHandle)
		{
		}
        #pragma endregion

        #pragma region DSMgr
    
        virtual void RegisterDSMgrCallback(SMART_PTR_NS::shared_ptr<CSFUnified::DSMgrCallback> dsMgrCallback)
		{
		}
        virtual void UnregisterDSMgrCallback(SMART_PTR_NS::shared_ptr<CSFUnified::DSMgrCallback> dsMgrCallback)
		{
		}
        virtual bool CanStartSharing(std::string strSessionName)
		{
			return false;
		}
        virtual bool CancelStartSharing()
		{
			return false;
		}
        virtual bool IsInsharing()
		{
			return false;
		}
        virtual bool Start(std::string strSessionName)
		{
			return false;
		}
        virtual bool Join(std::string strSessionName)
		{
			return false;
		}
        virtual bool Decline(std::string strSessionName)
		{
			return false;
		}
        virtual bool StopCurSession()
		{
			return false;
		}
        virtual bool ReInviteCurSession()
		{
			return false;
		}
        virtual bool ReSharing()
		{
			return false;
		}
        virtual bool ChangePresenter()
		{
			return false;
		}
        virtual bool IsPresenter()
		{
			return false;
		}
        virtual bool CanJoinSharing(std::string strSessionName, int eType)
		{
			return false;
		}
        #pragma endregion

        #pragma region MeetingMgr
    
        virtual void RegisterMeetingMgrCallback(SMART_PTR_NS::shared_ptr<CSFUnified::MeetingMgrCallback> meetingMgrCallback)
		{
		}
        virtual void UnregisterMeetingMgrCallback(SMART_PTR_NS::shared_ptr<CSFUnified::MeetingMgrCallback> meetingMgrCallback)
		{
		}
        virtual DWORD ListMeetings(SYSTEMTIME stSelectedDay)
		{
			return 0;
		}
        virtual DWORD RefreshMeetings()
		{
			return 0;
		}
        virtual DWORD TodayChanged(bool bForceChanged)
		{
			return 0;
		}
        virtual DWORD GetWbxMeetingDetail(std::string strEventID)
		{
			return 0;
		}
        virtual DWORD ViewMeeting(std::string strMeetingID)
		{
			return 0;
		}
        virtual DWORD LaunchWebexMeeting(std::string strEventID)
		{
			return 0;
		}
        virtual CSFUnified::MailServiceTypeEnum::MailServiceType GetCurrentMailType()
		{
			return static_cast<CSFUnified::MailServiceTypeEnum::MailServiceType>(0);
		}
        virtual DWORD SendEmail(std::string strSubject, std::string strTos, std::string strBody, std::string strMeetingKey)
		{
			return 0;
		}
        #pragma endregion

        #pragma region CalendarIntegration
    
		virtual CSFUnified::DefaultMailClientTypeEnum::DefaultMailClientType GetDefaultMailClient()
		{
			return CSFUnified::DefaultMailClientTypeEnum::NONE;
		}
        #pragma endregion

        #pragma region Common
    
        virtual void Loggedin()
		{
		}
        virtual void LoggedOut()
		{
		}

		virtual void getCMRInfo(std::string meetingKeyList) {}
};

#endif
